
document.addEventListener('DOMContentLoaded', () => {
  const btn = document.getElementById('startBtn');
  const statusDiv = document.getElementById('status');

  // Check if we are already running
  chrome.storage.local.get(['isScraping', 'progressMessage'], (data) => {
    if (data.isScraping) {
      btn.disabled = true;
      btn.innerText = "Extraction in Progress...";
    }
    if (data.progressMessage) {
      statusDiv.innerText = data.progressMessage;
    }
  });

  // Listen for updates
  chrome.storage.onChanged.addListener((changes) => {
    if (changes.progressMessage) {
      statusDiv.innerText = changes.progressMessage.newValue;
    }
    if (changes.isScraping) {
      if (!changes.isScraping.newValue) {
        btn.disabled = false;
        btn.innerText = "Start Extraction";
      } else {
        btn.disabled = true;
        btn.innerText = "Extraction in Progress...";
      }
    }
  });

  btn.addEventListener('click', () => {
    chrome.tabs.query({active: true, currentWindow: true}, (tabs) => {
      const tab = tabs[0];
      if (!tab.url.includes('youtube.com')) {
        statusDiv.innerText = "Please go to youtube.com/feed/playlists first.";
        return;
      }
      
      btn.disabled = true;
      btn.innerText = "Starting...";
      statusDiv.innerText = "Initializing...";
      
      // Send message to background to start
      chrome.runtime.sendMessage({ action: "START_PROCESS", tabId: tab.id, url: tab.url });
    });
  });
});
